function y_suivant= RK_4(func,t_courant,h,y_courant,varargin)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Intgrateur d'quations diffrentielles ordinaires du premier ordre selon
% le schma de Runge Kutta d'ordre 4.
% func est une fonction prenant en entre t (temps) et y (tat du systme) 
% et donnant y' (drive de l'tat du systme) en sortie
% t_courant est le temps de simulation courant
% h est le pas de temps
% y_courant est l'tat courant du systme
% varargin contient toutes les paramtres complmentaires ncessaires 
% l'excution de func
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% transformation de la chaine de caractres func en une fonction
% interprtable par matlab
func=str2func(func);
% calcul des incrments
alpha=h*func(t_courant,y_courant,varargin{:});
beta=h*func(t_courant+h/2,y_courant+alpha/2,varargin{:});
gamma=h*func(t_courant+h/2,y_courant+beta/2,varargin{:});
delta=h*func(t_courant+h,y_courant+gamma,varargin{:});
% maj de l'tat
y_suivant=y_courant+(1/6)*(alpha+2*beta+2*gamma+delta);


end

