function X=Trace_3axes_trajectoire(q,p,specs,t_trace)
%trac trajectoire relle du robot  partir de q=3*n chantillons
%trac trajectoire attendue du robot  partir de p=2 positions
% t_trace temps de pause entre chaque trac
figure
hold on
grid on
plot3(p(1,1:2),p(2,1:2),p(3,1:2),'ok','LineWidth',3);
n=numel(q(1,:));

l1=0.0935;
l2=0.1075;
w=[];
%remapping
for i=1:n
q1=q(1,i);
q2=q(2,i);
q3=q(3,i);

T01=[cos(q1) -sin(q1) 0 0
    sin(q1) cos(q1) 0 0 
    0 0 1 0
    0 0 0 1];
T12=[0 -1 0 0
    0 0 -1 -q2
    1 0 0 0
    0 0 0 1];
T23=[cos(q3) -sin(q3) 0 0 
    0 0 -1 0
    sin(q3) cos(q3) 0 0
    0 0 0 1];
 P3=[0 -specs.l3 0 1]';%position du point P dans le repre 3
T=T01*T12*T23;

Xpp=(T*P3)';
X=[0 0 0
   T(1:3,4)' 
   Xpp(1:3)];
w=[w;X(3,:)];
hold off
plot3(X(1:3,1),X(1:3,2),X(1:3,3),'LineWidth',3);
hold on
grid on
plot3(X(1:3,1),X(1:3,2),X(1:3,3),'or','LineWidth',3);
plot3(p(1,1:2),p(2,1:2),p(3,1:2),'ok','LineWidth',3);
plot3(w(:,1),w(:,2),w(:,3),'--g','LineWidth',3);
        axis([-0.5 0.5 -0.5 0.5 -0.25 0.05])
        %set(gca,'DataAspectRatio',[1 1 1]);
        view(45,45);
        xlabel('X(m)','FontSize',24);
        ylabel('Y(m)','FontSize',24);
        zlabel('Z(m)','FontSize',24);
        pause(t_trace);
end
end