%% MODELE MANIPULATEUR 6 AXES
%% Matrices de transformation homogne
syms q1 q2 q3 q4 q5 q6 real
syms l1 l2 real
T01=[cos(q1) -sin(q1) 0 0;sin(q1) cos(q1) 0 0; 0 0 1 0; 0 0 0 1];%ok
T12=[cos(q2) -sin(q2) 0 0;0 0 1 0; -sin(q2) -cos(q2) 0 0; 0 0 0 1];%ok
T23=[cos(q3) -sin(q3) 0 l1;sin(q3) cos(q3) 0 0; 0 0 1 0; 0 0 0 1];%ok
T34=[cos(q4) -sin(q4) 0 0;0 0 1 l2;-sin(q4) -cos(q4) 0 0; 0 0 0 1];
T45=[cos(q5) -sin(q5) 0 0;0 0 -1 0; sin(q5) cos(q5) 0 0; 0 0 0 1];
T56=[cos(q6) -sin(q6) 0 0;0 0 1 0; -sin(q6) -cos(q6) 0 0; 0 0 0 1];

%% MGD
T06=simplify(T01*T12*T23*T34*T45*T56);

%% Dfinition de la pose dsire U0
syms r11 r12 r13 r21 r22 r23 r31 r32 r33 px py pz real;
U0=[r11 r12 r13 px;r21 r22 r23 py;r31 r32 r33 pz;0 0 0 1];

%% Rsolution de l'quation d'orientation
P=[px py pz 1]';
PT=T01*T12*T23*T34*[0 0 0 1]';
q1s=atan2(py,px);
% equation 1
% a=simplify(inv(T01)*P);
% b=T12*T23*T34*[0 0 0 1]';
% eqn=px*(a(1)-b(1))+py*(a(2)-b(2))==0;
% q1s=isolate(py*cos(q1)==px*sin(q1),q1);
% eqns=a(1:2)-b(1:2)==[0 0]';

R0=[r11 r12 r13;r21 r22 r23;r31 r32 r33];

R01=[cos(q1) -sin(q1) 0 ;sin(q1) cos(q1) 0 ; 0 0 1];%ok
R12=[cos(q2) -sin(q2) 0 ;0 0 1 ; -sin(q2) -cos(q2) 0 ];%ok
R23=[cos(q3) -sin(q3) 0 ;sin(q3) cos(q3) 0 ; 0 0 1];%ok
R34=[cos(q4) -sin(q4) 0 ;0 0 1 ;-sin(q4) -cos(q4) 0 ];
R45=[cos(q5) -sin(q5) 0 ;0 0 -1 ; sin(q5) cos(q5) 0 ];
R56=[cos(q6) -sin(q6) 0 ;0 0 1 ; -sin(q6) -cos(q6) 0 ];

%soit [F G H] la forme de  R30*R0 connue
% premire quation mthode de Paul
syms F1 F2 F3 G1 G2 G3 H1 H2 H3 real
F=[F1 F2 F3]';
G=[G1 G2 G3]';
H=[H1 H2 H3]';
FGH=simplify((R01*R12*R23)'*R0);
A=simplify(R34'*[F G H]);
B=simplify(R45*R56);

q4s=isolate(A(2,3)==B(2,3),q4);
% deuxime quation mthode de Paul
C=simplify(R0*(R56'*R45'*R34'));
D=simplify((R01*R12*R23));
