function J=Jnum(MGDD,qc,dp,rob)
%gives a numerical approximation of the Jacobian for the considered forward kinematics at a configuration qc
% MGD Direct geometric model of the considered leg/robot
% qc Current leg/robot configuration
% dp numerical differentiation step size
% rob leg/robot characteristics

MGDD=str2func(MGDD);
nq=length(qc); % number of joint coordinates
%ref=(feval(MGD,qc,rob)); % current operational coordinates of the leg/robot 
[ref,w1,w2]=MGDD(qc,rob);
nx=length(ref); % number of operational coordinates
J=zeros(nx,nq); % jacobian initialization

for j=1:nq
dq=zeros(nq,1); %differentiation step vector 
dq(j)=dp;
%distu=(feval(MGD,qc+dq,rob));% infinitesimal variation of the MGD
[distu1,w1,w2]=MGDD(qc+dq,rob);
[distu2,w1,w2]=MGDD(qc-dq,rob);
J(:,j)=(distu1-distu2)/(2*dp); % Jacobian computation
end
end