function [t,q,dq,ddq]=lines_min_jerk(specs,Xpoints,tpoints,dt)

%Here it is a suite of straight trajectories pursued in min jerk
%Xpoints contains a suite of coordinates to reach (firt one is the start of
%the trajectories)
%Flash, Tamar, and Neville Hogan. "The coordination of arm movements: an experimentally confirmed mathematical model." The journal of Neuroscience 5.7 (1985): 1688-1703.

k1=numel(Xpoints(1,:))-1;%number of trajectories
Xtarg=Xpoints;
for i=1:k1

if i==1
    t=0:dt:tpoints(i);
for j=1:numel(t)
X(:,j)=Xtarg(:,i)+(Xtarg(:,i)-Xtarg(:,i+1))*(15*(t(j)/tf(i))^4-6*(t(j)/tf(i))^5-10*(t(j)/tf(i))^3);
end
else
    ttemp1=0:dt:tpoints(i);
    for j=1:numel(ttemp1)
    Xp(:,j)=Xtarg(:,i)+(Xtarg(:,i)-Xtarg(:,i+1))*(15*(ttemp1(j)/tf(i))^4-6*(ttemp1(j)/tf(i))^5-10*(ttemp1(j)/tf(i))^3);
    end
    [X,t]=concat_motion(X,Xp,t,ttemp1,dt);
end


end