function q=MGI_6axes_analytique(T,specs)

l1=specs.l1;
l2=specs.l2;
q=zeros(6,1);%initialisation du vecteur q

%calcul de q1
q(1)=atan2(T(2,4),T(1,4));

%calcul de q3
px1=T(1,4)*cos(q(1))+T(2,4)*sin(q(1));
cq3=(px1^2+T(3,4)^2-l1^2-l2^2)/(2*l1*l2);
sq3=sqrt(1-cq3^2);
q3=atan2(sq3,cq3);
q(3)=-(q3+pi/2);

%calcul de q2
q2=atan2(T(3,4),px1)-atan2(l2*sq3,l1+l2*cq3);
q(2)=-q2;



end