function [q,q_alt]=MGI_6axes(T,specs)

% modle gomtrique inverse du robot 6 axes
%attention aux choix multiples !
l1=specs.l1;
l2=specs.l2;
q=zeros(6,1);
q_alt=zeros(6,8);

%q_1
q(1)=atan2(T(2,4),T(1,4));
%q_3
cq3=(T(3,4)^2+(T(1,4)*cos(q(1))+T(2,4)*sin(q(1)))^2-l1^2-l2^2)/(2*l1*l2);


sq3=sqrt(1-cq3^2);
q(3)=atan2(sq3,cq3);

q(2)=-atan2(T(3,4),T(1,4)*cos(q(1))+T(2,4)*sin(q(1)))-atan2(l2*sin(q(3)),l1+l2*cos(q(3)));

q(3)=atan2(sq3,cq3)-pi/2;
R01=[cos(q(1)) -sin(q(1)) 0 ;sin(q(1)) cos(q(1)) 0 ; 0 0 1];%ok
R12=[cos(q(2)) -sin(q(2)) 0 ;0 0 1 ; -sin(q(2)) -cos(q(2)) 0 ];%ok
R23=[cos(q(3)) -sin(q(3)) 0 ;sin(q(3)) cos(q(3)) 0 ; 0 0 1];%ok

FGH=(R01*R12*R23)'*T(1:3,1:3);

q(4)=atan2(-FGH(3,3),FGH(1,3));
q(5)=atan2(FGH(3,3)*sin(q(4))-FGH(1,3)*cos(q(4)),FGH(2,3));
q(6)=atan2(-FGH(3,1)*cos(q(4))-FGH(1,1)*sin(q(4)),-FGH(3,2)*cos(q(4))-FGH(1,2)*sin(q(4)));



% R34=[cos(q4) -sin(q4) 0 ;0 0 1 ;-sin(q4) -cos(q4) 0 ];
% R45=[cos(q5) -sin(q5) 0 ;0 0 -1 ; sin(q5) cos(q5) 0 ];
% R56=[cos(q6) -sin(q6) 0 ;0 0 1 ; -sin(q6) -cos(q6) 0 ];


end