%% PARAMETRAGE

% Paramètres du modèle
% ne pas oublier de mettre un préfixe devant les paramètres du modèle

%paramètres géométriques
syms sym_l1 sym_l2 sym_a sym_b real
%paramètres inertiels
syms sym_m1 sym_m2 sym_I1 sym_I2 real

% Paramètres du mouvement
syms q1 q2 dq1 dq2 ddq1 ddq2 real

q=[q1 q2]';
dq=[dq1 dq2]';
ddq=[ddq1 ddq2]';
n=numel(q);
% Paramètres d'efforts

syms Fx Fy real

Fext=[Fx Fy 0]';
% Autres
syms g real %gravité

%% Matrices de transformation homogène

T01=[cos(q1) -sin(q1) 0 0
     sin(q1)  cos(q1) 0 0   
     0        0       1 0
     0        0      0 1];
 
 T12=[cos(q2) -sin(q2) 0 sym_l1
     sin(q2)  cos(q2) 0 0   
     0        0       1 0
     0        0      0 1];
 T02=simplify(T01*T12);

%% Positions des centres de masse

c1=[sym_a 0 0 1]';%dans le repère 1
c2=[sym_b 0 0 1]';%dans le repère 2

c01=T01*c1;
c02=T02*c2;


%% Vitesses des centres de masse
vc01=simplify(jacobian(c01(1:3),q)*dq);
vc02=simplify(jacobian(c02(1:3),q)*dq);

%% Energie cinétique

% ATTENTION A BIEN EXPRIMER L'ENSEMBLE DES QUANTITES DANS LA MEME
% BASE

T1=simplify((1/2)*vc01'*sym_m1*vc01+(1/2)*sym_I1*dq1^2);
T2=simplify((1/2)*vc02'*sym_m2*vc02+(1/2)*sym_I2*(dq1+dq2)^2);
T=simplify(T1+T2);

%% Energie potentielle

Ep1=sym_m1*g*c01(2);
Ep2=sym_m2*g*c02(2);
Ep=Ep1+Ep2;

%% Calcul de H

H_temp=simplify(gradient(T,dq));
H=simplify(jacobian(H_temp,dq));


%% Calcul de G

G=simplify(gradient(Ep,q));

%% Calcul de C

syms C real

for i=1:n
    for j=1:n
        C(i,j)=0*g;
        for k=1:n
            C(i,j)=C(i,j)+(1/2)*(diff(H(i,j),q(k))+diff(H(i,k),q(j))-diff(H(j,k),q(i)))*dq(k);
        end
    end
end
C=simplify(C);

%% Calcul de F
O2=T02*[sym_l2 0 0  1]';

F=simplify(jacobian(O2(1:3),q)'*Fext);

%% Modèle dynamique inverse
Tau=simplify(H*ddq+C*dq+G-F);

%% Modèle dynamique direct
syms tau1 tau2 real
ddqp=simplify(H^-1*([tau1 tau2]'+F-C*dq-G));

